/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.esl.energy;

import org.antarcticgardens.esl.energy.EnergyStorage;
import org.antarcticgardens.esl.transaction.SnapshotParticipant;
import org.antarcticgardens.esl.transaction.TransactionContext;

public class SimpleEnergyStorage
extends SnapshotParticipant<Long>
implements EnergyStorage {
    private long capacity;
    private long stored = 0L;
    private boolean supportsInsertion = true;
    private boolean supportsExtraction = true;
    private long maxExtract = Long.MAX_VALUE;
    private long maxInsert = Long.MAX_VALUE;
    private Runnable finalCommitCallback = () -> {};

    public SimpleEnergyStorage(long capacity) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("SimpleEnergyStorage capacity can't be negative");
        }
        this.capacity = capacity;
    }

    public SimpleEnergyStorage onFinalCommit(Runnable callback) {
        this.finalCommitCallback = callback;
        return this;
    }

    public SimpleEnergyStorage setCapacity(long capacity) {
        this.capacity = capacity;
        this.stored = Math.min(this.stored, capacity);
        return this;
    }

    public SimpleEnergyStorage setSupportsInsertion(boolean supportsInsertion) {
        this.supportsInsertion = supportsInsertion;
        return this;
    }

    public SimpleEnergyStorage setSupportsExtraction(boolean supportsExtraction) {
        this.supportsExtraction = supportsExtraction;
        return this;
    }

    public SimpleEnergyStorage setMaxExtract(long maxExtract) {
        this.maxExtract = maxExtract;
        return this;
    }

    public SimpleEnergyStorage setMaxInsert(long maxInsert) {
        this.maxInsert = maxInsert;
        return this;
    }

    public SimpleEnergyStorage setStoredEnergy(long amount) {
        this.stored = Math.max(0L, Math.min(amount, this.capacity));
        return this;
    }

    @Override
    protected void onFinalCommit() {
        this.finalCommitCallback.run();
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public long getStoredEnergy() {
        return this.stored;
    }

    @Override
    public Long createSnapshot() {
        return this.stored;
    }

    @Override
    public void restoreSnapshot(Long snapshot) {
        this.stored = snapshot;
    }

    @Override
    public long insert(long amount, TransactionContext context) {
        if (!this.supportsInsertion) {
            return 0L;
        }
        this.updateSnapshots(context);
        long inserted = Math.min(Math.min(amount, this.maxInsert), this.capacity - this.stored);
        this.stored += inserted;
        return inserted;
    }

    @Override
    public long extract(long amount, TransactionContext context) {
        if (!this.supportsExtraction) {
            return 0L;
        }
        this.updateSnapshots(context);
        long extracted = Math.min(Math.min(amount, this.maxExtract), this.stored);
        this.stored -= extracted;
        return extracted;
    }

    public long internalInsert(long amount, boolean simulated) {
        long inserted = Math.min(amount, this.capacity - this.stored);
        if (simulated) {
            return inserted;
        }
        this.stored += inserted;
        return inserted;
    }

    public long internalExtract(long amount, boolean simulated) {
        long extracted = Math.min(amount, this.stored);
        if (simulated) {
            return extracted;
        }
        this.stored -= extracted;
        return extracted;
    }

    @Override
    public boolean supportsExtraction() {
        return this.supportsExtraction;
    }

    @Override
    public boolean supportsInsertion() {
        return this.supportsInsertion;
    }
}

